@extends('layouts.app')

@section('title', $package->name)

@section('content')
<div class="store-container">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 offset-lg-1">
                <div class="store-package-detail">
                    <div class="store-package-detail-image" style="background-image: url('{{ asset('storage/' . $package->image_path ?? 'images/store/default.jpg') }}')">
                        @if(Str::contains(strtolower($package->name), 'elite') && $package->type === 'vip')
                            <div class="store-package-badge">Elite</div>
                        @endif
                    </div>
                    
                    <div class="store-package-detail-content">
                        @if($server)
                        <div class="package-server-info">
                            <span class="server-badge">Available on: {{ $server->name }}</span>
                        </div>
                        @endif
                        
                        <div class="store-package-detail-header">
                            <h1>{{ $package->name }}</h1>
                            <div class="price">{{ currency_symbol(config_value('store_currency', 'GBP')) }}{{ number_format($package->price, 2) }}</div>
                        </div>
                        
                        <div class="store-package-detail-description">
                            <p>{{ $package->description }}</p>
                        </div>
                        
                        <div class="store-package-detail-features">
                            <h3>What's Included</h3>
                            <ul>
                                @foreach($package->features as $feature)
                                <li><span class="check-icon">✓</span>{{ $feature }}</li>
                                @endforeach
                            </ul>
                        </div>
                        
                        <div class="store-package-detail-actions">
                            @auth
                                <a href="{{ route('store.payment.checkout', ['slug' => $package->slug, 'server_id' => $server ? $server->id : null]) }}" class="btn-purchase">Purchase Now</a>
                            @else
                                <div class="login-required">
                                    <p>You need to be logged in to purchase this package.</p>
                                    <a href="{{ route('login.steam') }}" class="btn-login">Login</a>
                                </div>
                            @endauth
                        </div>
                    </div>
                    
                    <div class="store-package-detail-footer">
                        <a href="{{ route('store.index', $server ? ['server_id' => $server->id] : []) }}" class="btn-back">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
                            </svg>
                            Back to Store
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection